/**
  ******************************************************************************
  * @file    flash_interface.h
  * @author  MCD Application Team
  * @brief   Header for flash_interface.c module
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef FLASH_INTERFACE_H
#define FLASH_INTERFACE_H

/* Includes ------------------------------------------------------------------*/
/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */

void OPENBL_FLASH_Lock(void);
void OPENBL_FLASH_Read(uint32_t Address, uint8_t *Data, uint32_t DataLength);
void OPENBL_FLASH_Write(uint32_t Address, uint8_t *Data, uint32_t DataLength);
void OPENBL_FLASH_Unlock(void);
ErrorStatus OPENBL_FLASH_EraseChip(void);
ErrorStatus OPENBL_FLASH_EraseBank(uint32_t Address);
//ErrorStatus OPENBL_FLASH_EraseBlock(uint32_t Address);
ErrorStatus OPENBL_FLASH_EraseSector(uint32_t Address);
ErrorStatus OPENBL_FLASH_ErasePage(uint32_t Address);
void OPENBL_FLASH_JumpToAddress(uint32_t Address);

#endif /* FLASH_INTERFACE_H */


